//////////////////////////////////////////////
// Camera.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkGraphicsTests.CameraManager = class CameraManager extends nkDebug.TestClass
{
	static instance = new CameraManager ("nkGraphicsTests.CameraManager") ;

	nkTests =
	{
		__testInit__ : function ()
		{
			// Init nkGraphics
			const s = nkGraphics.System.getInstance() ;

			const initResult = s.initialize() ;

			if (!initResult)
				console.log("Failure to initialize nkGraphics, bypassing Camera test...")

			return initResult ;
		},
		__testShutdown__ : function ()
		{
			nkGraphics.System.getInstance().shutdown()  ;
			nkGraphics.System.kill() ;
		},

		CameraAutoUpdate : function ()
		{
			const baseRatio = 2 ;

			// Prepare cameras we will test with
			const camInstancing = nkGraphics.CameraManager.getInstance().createOrRetrieve("testCamInstancing") ;
			camInstancing.setAspectRatio(baseRatio) ;

			const camMono = nkGraphics.CameraManager.getInstance().createOrRetrieve("testCamMono") ;
			camMono.setAspectRatio(baseRatio) ;

			const camPost = nkGraphics.CameraManager.getInstance().createOrRetrieve("testCamPost") ;
			camPost.setAspectRatio(baseRatio) ;

			const camScene = nkGraphics.CameraManager.getInstance().createOrRetrieve("tesetCamScene") ;
			camScene.setAspectRatio(baseRatio) ;

			// Gather some data
			const shader = nkGraphics.ShaderManager.getInstance().get(nkGraphics.ShaderManager.DEFAULT_EMPTY_SHADER) ;

			nkDebug.TestUtils.check(shader, "Shader is null") ;
		}
	}
}